<?php

namespace App\Http\Controllers\Admin; // PERBAIKAN DI SINI: menggunakan backslash \

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User; // PERBAIKAN DI SINI: menggunakan backslash \
use App\Models\Item; // PERBAIKAN DI SINI: menggunakan backslash \
use App\Models\Borrowing; // PERBAIKAN DI SINI: menggunakan backslash \

class DashboardController extends Controller
{
    public function index()
    {
        $totalUsers = User::count();
        $totalItems = Item::count();
        $pendingBorrowings = Borrowing::where('status', 'pending')->count();
        $approvedBorrowings = Borrowing::where('status', 'approved')->count();

        return view('admin.dashboard', compact('totalUsers', 'totalItems', 'pendingBorrowings', 'approvedBorrowings'));
    }

    public function getPendingRequestsCount()
    {
        $pendingCount = Borrowing::where('status', 'pending')->count();
        return response()->json(['pending_count' => $pendingCount]);
    }
}
