<?php

namespace App\Http\Controllers; // Pastikan ini sudah benar

use App\Models\Item;
use App\Models\Borrowing;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class GuestBorrowController extends Controller
{
    /**
     * Menampilkan form peminjaman untuk tamu.
     */
    public function create()
    {
        // Hanya tampilkan barang yang tersedia
        $items = Item::where('status', 'available')->where('quantity', '>', 0)->orderBy('name')->get();
        return view('guest.borrow', compact('items'));
    }

    /**
     * Memproses pengajuan peminjaman dari tamu.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'guest_name' => 'required|string|max:255',
            'guest_class' => 'required|string|max:255',
            'item_id' => 'required|exists:items,id',
            'quantity' => 'required|integer|min:1',
            'borrow_date' => 'required|date|after_or_equal:today',
            'borrow_time' => 'required|date_format:H:i',
            'notes' => 'nullable|string|max:500',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $item = Item::find($request->item_id);

        if (!$item || $item->status !== 'available' || (int)$request->quantity > (int)$item->quantity) {
            return redirect()->back()->withInput()->with('error', 'Kuantitas yang diminta melebihi stok yang tersedia, atau barang tidak tersedia/valid.');
        }

        Borrowing::create([
            'user_id' => null, // Karena ini peminjam tamu
            'item_id' => $request->item_id,
            'quantity' => $request->quantity,
            'guest_name' => $request->guest_name,
            'guest_class' => $request->guest_class,
            'borrow_date' => $request->borrow_date,
            'borrow_time' => $request->borrow_time,
            'notes' => $request->notes,
            'status' => 'pending',
        ]);

        // Pengalihan kembali ke form dengan pesan sukses (bukan halaman detail)
        return redirect()->back()->with('success', 'Pengajuan peminjaman Anda berhasil dikirim! Silakan tunggu konfirmasi dari admin.');
    }

    // showSuccessDetail DIHAPUS
    // public function showSuccessDetail(Borrowing $borrowing) { ... }
}