<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item;
use App\Models\Borrowing;

class DashboardController extends Controller
{
    public function index()
    {
        $availableItems = Item::where('quantity', '>', 0)->count();
        $myPendingBorrowings = Borrowing::where('user_id', auth()->id())
                                        ->where('status', 'pending')
                                        ->count();
        $myApprovedBorrowings = Borrowing::where('user_id', auth()->id())
                                         ->where('status', 'approved')
                                         ->count();

        return view('user.dashboard', compact('availableItems', 'myPendingBorrowings', 'myApprovedBorrowings'));
    }
}