<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Borrowing extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'item_id',
        'quantity',         // Pastikan ini ada
        'guest_name',
        'guest_class',
        'borrow_date',
        'borrow_time',      // Pastikan ini ada
        'return_date',
        'return_time',      // Pastikan ini ada
        'status',
        'notes',
    ];

    // Relasi ke tabel users
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relasi ke tabel items
    public function item()
    {
        return $this->belongsTo(Item::class);
    }
}