<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('borrowings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null'); // Bisa NULL untuk tamu
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade'); // Barang yang dipinjam

            // Kolom quantity (PENTING: PASTIKAN INI ADA)
            $table->integer('quantity');

            // Kolom untuk peminjam tamu
            $table->string('guest_name')->nullable();
            $table->string('guest_class')->nullable();

            // Kolom untuk tanggal dan jam peminjaman
            $table->date('borrow_date');
            $table->time('borrow_time');

            // Kolom untuk tanggal dan jam pengembalian (bisa null jika belum dikembalikan)
            $table->date('return_date')->nullable();
            $table->time('return_time')->nullable();

            $table->text('notes')->nullable(); // Catatan tambahan
            $table->string('status')->default('pending'); // pending, approved, rejected, returned

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('borrowings');
    }
};