<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Hapus user yang sudah ada (opsional, untuk memastikan tidak ada duplikasi jika seeder dijalankan berkali-kali)
        DB::table('users')->truncate(); 

        // Akun Admin
        DB::table('users')->insert([
            'name' => 'Admin Lab TJKT',
            'email' => 'admin@labtjkt.com',
            'password' => Hash::make('password'), // Password default: password
            'role' => 'admin',
            'email_verified_at' => now(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Akun User Biasa
        DB::table('users')->insert([
            'name' => 'User Peminjam',
            'email' => 'user@peminjam.com',
            'password' => Hash::make('password'), // Password default: password
            'role' => 'user',
            'email_verified_at' => now(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}