<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Monitoring Peminjaman') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Daftar Semua Peminjaman & Riwayat') }}</h3>

                @if (session('success'))
                    <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
                    </div>
                @endif
                @if (session('error'))
                    <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
                    </div>
                @endif

                <div class="overflow-x-auto bg-gray-50 dark:bg-gray-700 rounded-xl shadow-lg border border-gray-200 dark:border-gray-600">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Peminjam (Nama / Kelas)
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Barang
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Jumlah
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Tgl & Jam Pinjam
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Tgl & Jam Kembali
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Status
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Keperluan / Catatan
                                </th>
                                <th scope="col" class="px-6 py-4 text-right text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Aksi
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($borrowings as $borrowing)
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <td class="px-6 py-4 whitespace-nowrap text-base font-medium text-gray-900 dark:text-gray-100">
                                        @if ($borrowing->user)
                                            <span class="font-bold">{{ $borrowing->user->name }}</span>
                                            <p class="text-xs text-gray-500 dark:text-gray-400">({{ $borrowing->user->email }})</p>
                                        @else
                                            <span class="font-bold">{{ $borrowing->guest_name }}</span>
                                            <p class="text-xs text-gray-500 dark:text-gray-400">(Tamu - {{ $borrowing->guest_class }})</p>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-900 dark:text-gray-100">
                                        @if($borrowing->item->code == 'BARANG-LAIN')
                                            {{ $borrowing->notes }} (Barang Lain)
                                        @else
                                            {{ $borrowing->item->name }} ({{ $borrowing->item->code }})
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ $borrowing->quantity }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        @if($borrowing->borrow_date && $borrowing->borrow_time)
                                            {{ \Carbon\Carbon::parse($borrowing->borrow_date . ' ' . $borrowing->borrow_time)->format('d M Y, H:i') }} WIB
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        @if($borrowing->return_date && $borrowing->return_time)
                                            {{ \Carbon\Carbon::parse($borrowing->return_date . ' ' . $borrowing->return_time)->format('d M Y, H:i') }} WIB
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base">
                                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                            @if ($borrowing->status == 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                            @elseif ($borrowing->status == 'approved') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                            @elseif ($borrowing->status == 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                            @elseif ($borrowing->status == 'returned') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                            @elseif ($borrowing->status == 'overdue') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100
                                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                            {{ ucfirst($borrowing->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-600 dark:text-gray-300 max-w-xs truncate" title="{{ $borrowing->notes }}">
                                        {{ $borrowing->notes ?? '-' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-base font-medium">
                                        {{-- Tombol Aksi Langsung (tanpa dropdown) --}}
                                        @if ($borrowing->status == 'pending')
                                            <form action="{{ route('admin.borrowings.approve', $borrowing) }}" method="POST" class="inline-block">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-wider hover:bg-green-700 focus:bg-green-700 active:bg-green-900 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm mr-2">
                                                    <i class="fas fa-check mr-1"></i> Setujui
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.borrowings.reject', $borrowing) }}" method="POST" class="inline-block" onsubmit="return confirm('Apakah Anda yakin ingin menolak peminjaman ini?');">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-wider hover:bg-red-700 focus:bg-red-700 active:bg-red-900 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm">
                                                    <i class="fas fa-times mr-1"></i> Tolak
                                                </button>
                                            </form>
                                        @elseif ($borrowing->status == 'approved' || $borrowing->status == 'overdue')
                                            <form action="{{ route('admin.borrowings.return', $borrowing) }}" method="POST" class="inline-block">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-wider hover:bg-blue-700 focus:bg-blue-700 active:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm">
                                                    <i class="fas fa-undo-alt mr-1"></i> Kembalikan
                                                </button>
                                            </form>
                                        @else
                                            <span class="text-gray-500 dark:text-gray-400 font-normal text-sm px-2 py-1 rounded-md bg-gray-100 dark:bg-gray-700">Tidak ada aksi</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="px-6 py-4 text-center text-base text-gray-600 dark:text-gray-300">
                                        <i class="fas fa-info-circle mr-2"></i> Belum ada permintaan atau riwayat peminjaman.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
