<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Tambah Item Inventaris Baru') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="max-w-md mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Formulir Penambahan Item Inventaris') }}</h3>
                <form method="POST" action="{{ route('admin.inventories.store') }}">
                    @csrf

                    <div class="mb-5">
                        <x-input-label for="name" :value="__('Nama Item Inventaris')" />
                        <x-text-input id="name" class="block mt-1 w-full p-3 text-base" type="text" name="name" :value="old('name')" required autofocus placeholder="Contoh: Meja Komputer Lab 1" />
                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="code" :value="__('Kode Item')" />
                        <x-text-input id="code" class="block mt-1 w-full p-3 text-base" type="text" name="code" :value="old('code')" required placeholder="Contoh: INV-MJ-001" />
                        <x-input-error :messages="$errors->get('code')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="serial_number" :value="__('Nomor Seri (Opsional)')" />
                        <x-text-input id="serial_number" class="block mt-1 w-full p-3 text-base" type="text" name="serial_number" :value="old('serial_number')" placeholder="Contoh: SN-ABC-123" />
                        <x-input-error :messages="$errors->get('serial_number')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="description" :value="__('Deskripsi (Opsional)')" />
                        <textarea id="description" name="description" class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" rows="4" placeholder="Contoh: Meja komputer berbahan kayu jati, ukuran 120x60 cm." style="resize: vertical;">{{ old('description') }}</textarea>
                        <x-input-error :messages="$errors->get('description')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="location" :value="__('Lokasi')" />
                        <x-text-input id="location" class="block mt-1 w-full p-3 text-base" type="text" name="location" :value="old('location')" placeholder="Contoh: Ruang Lab TJKT 1" />
                        <x-input-error :messages="$errors->get('location')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="condition" :value="__('Kondisi')" />
                        <select id="condition" name="condition" class="block w-full mt-1 p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                            <option value="Baik" @selected(old('condition') == 'Baik')>Baik</option>
                            <option value="Rusak Ringan" @selected(old('condition') == 'Rusak Ringan')>Rusak Ringan</option>
                            <option value="Rusak Berat" @selected(old('condition') == 'Rusak Berat')>Rusak Berat</option>
                            <option value="Perlu Perbaikan" @selected(old('condition') == 'Perlu Perbaikan')>Perlu Perbaikan</option>
                            <option value="Tidak Terpakai" @selected(old('condition') == 'Tidak Terpakai')>Tidak Terpakai</option>
                        </select>
                        <x-input-error :messages="$errors->get('condition')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="purchase_date" :value="__('Tanggal Pembelian (Opsional)')" />
                        <x-text-input id="purchase_date" class="block mt-1 w-full p-3 text-base" type="date" name="purchase_date" :value="old('purchase_date')" />
                        <x-input-error :messages="$errors->get('purchase_date')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="owner" :value="__('Kepemilikan (Opsional)')" />
                        <x-text-input id="owner" class="block mt-1 w-full p-3 text-base" type="text" name="owner" :value="old('owner')" placeholder="Contoh: Jurusan TJKT" />
                        <x-input-error :messages="$errors->get('owner')" class="mt-2" />
                    </div>

                    <div class="mb-7">
                        <x-input-label for="notes" :value="__('Catatan Tambahan (Opsional)')" />
                        <textarea id="notes" name="notes" class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" rows="4" placeholder="Contoh: Disumbangkan oleh alumni angkatan 2020." style="resize: vertical;">{{ old('notes') }}</textarea>
                        <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end">
                        <a href="{{ route('admin.inventories.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                            <i class="fas fa-times-circle mr-2"></i> {{ __('Batal') }}
                        </a>
                        <x-primary-button class="ms-0 px-6 py-3 shadow-md">
                            <i class="fas fa-save mr-2"></i> {{ __('Simpan Item') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>