<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Kelola Inventaris') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">

                <div class="flex justify-between items-center mb-8 flex-wrap gap-4"> {{-- Tambah flex-wrap gap-4 --}}
                    <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100">{{ __('Daftar Barang Inventaris Lab') }}</h3>
                    <div class="flex items-center gap-4"> {{-- Kelompokkan tombol tambah dan impor --}}
                        {{-- Form Impor Excel --}}
                        <form action="{{ route('admin.inventories.import') }}" method="POST" enctype="multipart/form-data" class="flex items-center gap-2">
                            @csrf
                            <label class="block">
                                <span class="sr-only">Choose file</span>
                                <input type="file" name="file" class="block w-full text-sm text-gray-500
                                file:mr-4 file:py-2 file:px-4
                                file:rounded-full file:border-0
                                file:text-sm file:font-semibold
                                file:bg-violet-50 file:text-violet-700
                                hover:file:bg-violet-100 dark:file:bg-gray-700 dark:file:text-gray-200 dark:hover:file:bg-gray-600
                                dark:text-gray-400 dark:border-gray-600
                                cursor-pointer"
                                accept=".xlsx,.xls,.csv" required/>
                            </label>
                            <button type="submit" class="inline-flex items-center px-6 py-3 bg-green-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-green-700 focus:bg-green-700 active:bg-green-900 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                                <i class="fas fa-file-import mr-2"></i> {{ __('Impor Excel') }}
                            </button>
                        </form>
                        {{-- Tombol Tambah Item Baru --}}
                        <a href="{{ route('admin.inventories.create') }}" class="inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-blue-700 focus:bg-blue-700 active:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                            <i class="fas fa-plus-circle mr-2 text-lg"></i> {{ __('Tambah Item Baru') }}
                        </a>
                    </div>
                </div>

                {{-- Notifikasi Session (error dari validasi impor akan muncul di sini) --}}
                @if (session('success'))
                    <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
                    </div>
                @endif
                @if (session('error'))
                    <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
                    </div>
                @endif

                <div class="overflow-x-auto bg-gray-50 dark:bg-gray-700 rounded-xl shadow-lg border border-gray-200 dark:border-gray-600">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Nama Item
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Kode
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Lokasi
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Kondisi
                                </th>
                                <th scope="col" class="px-6 py-4 text-right text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Aksi
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($inventories as $item)
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <td class="px-6 py-4 whitespace-nowrap text-base font-medium text-gray-900 dark:text-gray-100">
                                        {{ $item->name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ $item->code }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ $item->location ?? '-' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base">
                                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                            @if ($item->condition == 'Baik') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                            @elseif ($item->condition == 'Rusak Ringan' || $item->condition == 'Perlu Perbaikan') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                            @elseif ($item->condition == 'Rusak Berat') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                                {{ ucfirst($item->condition) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-base font-medium">
                                        <a href="{{ route('admin.inventories.show', $item) }}" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-200 mr-4 transition-colors">
                                            <i class="fas fa-eye"></i> Detail
                                        </a>
                                        <a href="{{ route('admin.inventories.edit', $item) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-200 mr-4 transition-colors">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('admin.inventories.destroy', $item) }}" method="POST" class="inline-block" onsubmit="return confirm('Apakah Anda yakin ingin menghapus item inventaris ini? Tindakan ini tidak dapat dibatalkan.');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-200 transition-colors">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 text-center text-base text-gray-600 dark:text-gray-300">
                                        <i class="fas fa-exclamation-circle mr-2"></i> Tidak ada item inventaris yang tersedia. Silakan <a href="{{ route('admin.inventories.create') }}" class="text-blue-600 dark:text-blue-400 hover:underline font-medium">tambah item baru</a>.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>