<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Detail Barang: ') . $item->name }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="max-w-lg mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Informasi Detail Barang') }}</h3>
                <div class="space-y-5">
                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Nama Barang') }}:</p>
                        <p class="text-xl font-bold text-gray-900 dark:text-gray-100 mt-1">{{ $item->name }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Kode Barang') }}:</p>
                        <p class="text-lg font-medium text-gray-900 dark:text-gray-100 mt-1">{{ $item->code }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Deskripsi') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->description ?? '-' }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Jumlah / Stok') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->quantity }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Status') }}:</p>
                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full mt-1
                            @if ($item->status == 'available') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                            @elseif ($item->status == 'broken') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                            @elseif ($item->status == 'maintenance') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                            {{ ucfirst($item->status) }}
                        </span>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Dibuat Pada') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->created_at->format('d M Y H:i') }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Terakhir Diperbarui') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->updated_at->format('d M Y H:i') }}</p>
                    </div>
                </div>

                <div class="flex justify-end mt-8 pt-4 border-t border-gray-200 dark:border-gray-700">
                    <a href="{{ route('admin.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                        <i class="fas fa-arrow-left mr-2"></i> {{ __('Kembali ke Daftar') }}
                    </a>
                    <a href="{{ route('admin.items.edit', $item) }}" class="inline-flex items-center px-6 py-3 bg-indigo-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                        <i class="fas fa-edit mr-2"></i> {{ __('Edit Barang') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>