<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Peminjaman Barang Lab TJKT - Tamu</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        laravel: '#ef3b2d',
                    }
                }
            }
        }
    </script>
</head>
<body class="font-sans antialiased bg-gray-100 dark:bg-gray-900 flex items-center justify-center min-h-screen p-4 sm:p-0">
    <div class="w-full max-w-md bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
        <div class="flex flex-col items-center justify-center mb-8">
            <img src="{{ asset('images/logo_jurusan_tjkt.png') }}" alt="Logo Jurusan TJKT" class="h-20 w-auto mb-4 object-contain">
            <h2 class="text-3xl font-extrabold text-gray-900 dark:text-white text-center">Form Peminjaman Tamu</h2>
            <p class="text-gray-600 dark:text-gray-400 text-base mt-2 text-center">Isi data diri dan barang yang ingin dipinjam dengan teliti.</p>
        </div>

        @if (session('success'))
            <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md transition-all duration-300 transform scale-y-100 origin-top" role="alert">
                <span class="block sm:inline font-bold"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
            </div>
        @endif

        @if (session('error'))
            <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md transition-all duration-300 transform scale-y-100 origin-top" role="alert">
                <span class="block sm:inline font-bold"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
            </div>
        @endif

        {{-- x-data dipindahkan ke div terpisah untuk mengisolasi state Alpine.js --}}
        <form method="POST" action="{{ route('guest.borrow.store') }}">
            @csrf

            <div x-data="{ selectedItemId: '{{ old('item_id', \App\Models\Item::where('code', 'BARANG-LAIN')->first()->id ?? '') }}',
                           availableStock: 'N/A',
                           isPlaceholder: false,
                           placeholderId: {{ \App\Models\Item::where('code', 'BARANG-LAIN')->first()->id ?? 0 }},
                           fetchStock: async function(itemId) {
                               if (!itemId || itemId == this.placeholderId) {
                                   this.availableStock = 'N/A';
                                   this.isPlaceholder = true;
                                   document.getElementById('quantity').setAttribute('max', 9999);
                                   return;
                               }
                               try {
                                   const response = await fetch(`/items/${itemId}/stock`);
                                   const data = await response.json();
                                   this.availableStock = data.quantity;
                                   this.isPlaceholder = data.is_placeholder;
                                   document.getElementById('quantity').setAttribute('max', data.quantity);
                                   if (data.quantity === 0 && document.getElementById('quantity').value > 0) {
                                       document.getElementById('quantity').value = 0;
                                   }
                               } catch (error) {
                                   console.error('Error fetching stock:', error);
                                   this.availableStock = 'Error';
                                   this.isPlaceholder = false;
                               }
                           } }"
                 x-init="fetchStock(selectedItemId)"> {{-- x-init untuk panggil saat load --}}

                <!-- Nama Lengkap -->
                <div class="mb-5">
                    <label for="guest_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Nama Lengkap</label>
                    <input type="text" name="guest_name" id="guest_name" value="{{ old('guest_name') }}"
                           class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white p-3 text-base transition-colors duration-200"
                           required autofocus placeholder="Contoh: Budi Santoso">
                    @error('guest_name')
                        <p class="text-red-500 text-xs mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>

                <!-- Kelas -->
                <div class="mb-5">
                    <label for="guest_class" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Kelas</label>
                    <input type="text" name="guest_class" id="guest_class" value="{{ old('guest_class') }}"
                           class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white p-3 text-base transition-colors duration-200"
                           required placeholder="Contoh: XII TJKT 2">
                    @error('guest_class')
                        <p class="text-red-500 text-xs mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>

                <!-- Barang yang Dipinjam -->
                <div class="mb-5">
                    <label for="item_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Barang yang Dipinjam</label>
                    <select id="item_id" name="item_id" x-model="selectedItemId" @change="fetchStock(selectedItemId)"
                            class="block w-full mt-1 p-3 text-base rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:focus:border-indigo-600 dark:focus:ring-indigo-600 transition-colors duration-200" required>
                        <option value="">-- Pilih Barang --</option>
                        @foreach ($items as $item)
                            <option value="{{ $item->id }}" {{ old('item_id') == $item->id ? 'selected' : '' }}>
                                @if($item->code == 'BARANG-LAIN')
                                    {{ $item->name }}
                                @else
                                    {{ $item->name }} (Stok: {{ $item->quantity }})
                                @endif
                            </option>
                        @endforeach
                    </select>
                    <x-input-error :messages="$errors->get('item_id')" class="mt-2" />
                    {{-- Tampilan Stok Tersedia Realtime --}}
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-2">
                        Stok Tersedia: <span x-text="availableStock" :class="{'font-bold': true, 'text-red-500': availableStock === 0, 'text-green-500': availableStock > 0 && availableStock !== 'N/A'}"></span>
                        <span x-show="availableStock === 0 && !isPlaceholder" class="ml-1 text-red-500">(Stok Habis!)</span>
                        <span x-show="isPlaceholder" class="ml-1 text-blue-500">(Tidak Berlaku untuk Barang Lain)</span>
                    </p>
                </div>

                <!-- Jumlah Pinjam -->
                <div class="mb-5">
                    <label for="quantity" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Jumlah Pinjam</label>
                    <input type="number" name="quantity" id="quantity" value="{{ old('quantity', 1) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white p-3 text-base transition-colors duration-200"
                           required min="1" x-bind:max="availableStock !== 'N/A' ? availableStock : 9999"
                           placeholder="Masukkan jumlah yang ingin dipinjam">
                    @error('quantity')
                        <p class="text-red-500 text-xs mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>

                <!-- Tanggal Peminjaman -->
                <div class="mb-5">
                    <label for="borrow_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Tanggal Peminjaman</label>
                    <input type="date" name="borrow_date" id="borrow_date" value="{{ old('borrow_date', date('Y-m-d')) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white p-3 text-base transition-colors duration-200"
                           required>
                    @error('borrow_date')
                        <p class="text-red-500 text-xs mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>

                <!-- Jam Peminjaman -->
                <div class="mb-5">
                    <label for="borrow_time" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Jam Peminjaman</label>
                    <input type="time" name="borrow_time" id="borrow_time" value="{{ old('borrow_time', date('H:i')) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white p-3 text-base transition-colors duration-200"
                           required>
                    @error('borrow_time')
                        <p class="text-red-500 text-xs mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>

                <!-- Catatan (Opsional / Wajib jika Barang Lain dipilih) -->
                <div class="mb-7">
                    <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Keperluan Peminjaman</label>
                    <textarea name="notes" id="notes" rows="4"
                              class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-indigo-600 rounded-md transition-colors duration-200"
                              x-bind:placeholder="selectedItemId == placeholderId ? 'Praktek' : 'Contoh: Untuk praktik jaringan, akan dikembalikan besok sore.'"
                              style="resize: vertical;">{{ old('notes') }}</textarea>
                    @error('notes')
                        <p class="text-red-500 text-sm mt-2"><i class="fas fa-times-circle mr-1"></i> {{ $message }}</p>
                    @enderror
                </div>
            </div> {{-- Tutup div x-data --}}

            <div class="flex items-center justify-end">
                <button type="submit"
                        class="inline-flex items-center px-6 py-3 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-lg font-semibold text-base text-white dark:text-gray-800 uppercase tracking-wider shadow-md
                               hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800
                               transition ease-in-out duration-150 transform hover:scale-105">
                    <i class="fas fa-paper-plane mr-2"></i> Ajukan Peminjaman
                </button>
            </div>
        </form>
    </div>
</body>
</html>
