<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Ajukan Peminjaman Baru') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Formulir Pengajuan Peminjaman') }}</h3>

                @if (session('success'))
                    <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md transition-all duration-300 transform scale-y-100 origin-top" role="alert">
                        <span class="block sm:inline font-bold"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
                    </div>
                @endif
                @if (session('error'))
                    <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md transition-all duration-300 transform scale-y-100 origin-top" role="alert">
                        <span class="block sm:inline font-bold"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
                    </div>
                @endif

                <form method="POST" action="{{ route('user.borrowings.store') }}">
                    @csrf

                    <div class="mb-5">
                        <x-input-label for="item_id" :value="__('Barang yang Dipinjam')" />
                        <select id="item_id" name="item_id"
                                class="block w-full mt-1 p-3 text-base rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-indigo-600 transition-colors duration-200" required>
                            <option value="">-- Pilih Barang --</option>
                            @foreach ($items as $item)
                                <option value="{{ $item->id }}" {{ old('item_id') == $item->id ? 'selected' : '' }}>
                                    {{ $item->name }} (Stok: {{ $item->quantity }})
                                </option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('item_id')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="quantity" :value="__('Jumlah Pinjam')" />
                        <x-text-input id="quantity" class="block mt-1 w-full p-3 text-base" type="number" name="quantity" :value="old('quantity', 1)" required min="1" placeholder="Masukkan jumlah yang ingin dipinjam" />
                        <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="borrow_date" :value="__('Tanggal Peminjaman')" />
                        <x-text-input id="borrow_date" class="block mt-1 w-full p-3 text-base" type="date" name="borrow_date" :value="old('borrow_date', date('Y-m-d'))" required />
                        <x-input-error :messages="$errors->get('borrow_date')" class="mt-2" />
                    </div>

                    <div class="mb-7">
                        <x-input-label for="notes" :value="__('Catatan (Opsional)')" />
                        <textarea id="notes" name="notes" rows="4"
                                  class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-indigo-600 rounded-md transition-colors duration-200"
                                  placeholder="Contoh: Untuk praktik jaringan, akan dikembalikan besok sore."
                                  style="resize: vertical;">{{ old('notes') }}</textarea>
                        <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end">
                        <a href="{{ route('user.my-borrowings.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                            <i class="fas fa-times-circle mr-2"></i> {{ __('Batal') }}
                        </a>
                        <x-primary-button class="ms-0 px-6 py-3 shadow-md">
                            <i class="fas fa-paper-plane mr-2"></i> {{ __('Ajukan Peminjaman') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>