<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\User\DashboardController as UserDashboardController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\BorrowingController;
use App\Http\Controllers\GuestBorrowController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\InventoryController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Rute dasar '/'
Route::get('/', function () {
    if (auth()->check()) {
        if (auth()->user()->isAdmin()) {
            return redirect()->route('admin.dashboard');
        } else {
            return redirect()->route('user.dashboard');
        }
    }
    return redirect()->route('login');
})->name('root');

// Rute '/dashboard' (setelah login)
Route::get('/dashboard', function () {
    if (auth()->check()) {
        if (auth()->user()->isAdmin()) {
            return redirect()->route('admin.dashboard');
        } else {
            return redirect()->route('user.dashboard');
        }
    }
    return redirect()->route('login');
})->middleware(['auth', 'verified'])->name('dashboard');

// Rute untuk Admin (membutuhkan autentikasi dan middleware 'admin')
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    Route::get('dashboard/pending-requests-count', [AdminDashboardController::class, 'getPendingRequestsCount'])->name('dashboard.pending-requests-count');

    Route::resource('items', ItemController::class);

    Route::get('borrowings', [BorrowingController::class, 'indexAdmin'])->name('borrowings.index');
    Route::put('borrowings/{borrowing}/approve', [BorrowingController::class, 'approve'])->name('borrowings.approve');
    Route::put('borrowings/{borrowing}/reject', [BorrowingController::class, 'reject'])->name('borrowings.reject');
    Route::put('borrowings/{borrowing}/return', [BorrowingController::class, 'markAsReturned'])->name('borrowings.return');

    Route::resource('inventories', InventoryController::class);
    Route::post('inventories/import', [InventoryController::class, 'import'])->name('inventories.import');

    Route::get('reports/daily', [ReportController::class, 'daily'])->name('reports.daily');
    Route::get('reports/daily/export', [ReportController::class, 'exportDailyReport'])->name('reports.daily.export');
});

// Rute untuk User (membutuhkan autentikasi dan verified email)
Route::middleware(['auth', 'verified'])->prefix('user')->name('user.')->group(function () {
    Route::get('/dashboard', [UserDashboardController::class, 'index'])->name('dashboard');

    Route::get('/items', [ItemController::class, 'indexUser'])->name('items.index');

    Route::get('/borrow', [BorrowingController::class, 'create'])->name('borrowings.create');
    Route::post('/borrow', [BorrowingController::class, 'store'])->name('borrowings.store');

    Route::get('/my-borrowings', [BorrowingController::class, 'indexUser'])->name('my-borrowings.index');

    // Route Sukses Peminjaman User
    Route::get('/borrowings/{borrowing}/success', [BorrowingController::class, 'showSuccessDetail'])->name('borrowings.success-detail');
});

// Rute Profil User (untuk semua yang terautentikasi, baik admin maupun user biasa)
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Rute untuk Peminjaman Tamu (Tidak memerlukan autentikasi)
Route::get('/borrow/guest', [GuestBorrowController::class, 'create'])->name('guest.borrow.create');
Route::post('/borrow/guest', [GuestBorrowController::class, 'store'])->name('guest.borrow.store');

// Route Sukses Peminjaman Tamu
Route::get('/borrow/guest/{borrowing}/success', [GuestBorrowController::class, 'showSuccessDetail'])->name('guest.borrowings.success-detail');

// Route API untuk Stok Barang Realtime
Route::get('/items/{item}/stock', [ItemController::class, 'getStockQuantity'])->name('items.stock');

require __DIR__.'/auth.php';